/**
 * Check if all processes are done (not running)
 * Processes state is now an array of jobs: [{job_id: 123, status: 'completed'}, ...]
 *
 * @param {object} processesStateRef Processes state reference
 * @return {boolean}
 */
export const areAllProcessesDone = (processesStateRef) => {
    if (!processesStateRef?.current || !Array.isArray(processesStateRef.current)) {
        return true; // No processes state or empty array
    }

    // A job is finished if status is 'completed', 'failed', or 'canceled'
    // A job is not finished if status is 'pending', 'generating_tasks', 'processing', or 'paused'
    const finishedStatuses = ['completed', 'failed', 'canceled'];

    for (const job of processesStateRef.current) {
        if (!job.status || !finishedStatuses.includes(job.status)) {
            return false; // Found a job that's not finished
        }
    }

    return true; // All jobs are finished
};
