/**
 * Check if all processes are done (not running)
 *
 * @param {object} processesStateRef Processes state reference
 * @return {boolean}
 */
export const areAllProcessesDone = (processesStateRef) => {
    if (!processesStateRef?.current) {
        return true; // No processes state
    }

    const processesStatesKeys = Object.keys(processesStateRef.current);
    for (const key of processesStatesKeys) {
        const subKeys = Object.keys(processesStateRef.current[key]);
        for (const subKey of subKeys) {
            const processInfo = processesStateRef.current[key][subKey];
            // Check if generating process is in 'start' status
            if (!processInfo?.generating || processInfo?.generating === 'start') {
                return false; // Found a process that's not done
            }

            // Process is not done if generating is not 'complete' or 'cancel'
            if (processInfo?.generating && processInfo?.generating !== 'complete' && processInfo?.generating !== 'cancel') {
                return false; // Found a process that's not done
            }
        }
    }
    return true; // All processes are done (not running)
};
