import {useEffect} from '@wordpress/element';
import {LIMITS} from "../../_data/chatbot/costs-limits";

export default function useCostTokenOnToggle({limitName, type, isDataReady, setLimits}) {
    useEffect(() => {
        if (isDataReady) {
            const removeUnit = type === 'cost' ? LIMITS.unitToken : LIMITS.unitCost;
            setLimits(prevState => ({
                ...prevState,
                [limitName]: [
                    ...(prevState[limitName] || []).map(item => {
                        if (item.unit === removeUnit) {
                            return {
                                ...item,
                                value: 0,
                                period: 0,
                            }
                        }
                        return item;
                    }),
                ]
            }));
        }
    }, [isDataReady, type]);
}