import ToggleButton from "../toggle-button";

export default function Toggle({label, onClick, isActive, disabled, children}) {
    const toggle = () => {
        if (!disabled) {
            onClick();
        }
    }

    return (
        <div className='lbaic-settings-toggle-holder lbaic-settings-toggle-h-42'>
            <div className="lbaic-settings-label">
                <label className={`lbaic-settings-label-in${disabled ? ' lbaic-settings-label-disabled' : ''}`} onClick={toggle}>{label}</label>
                {!!children && children}
            </div>
            <ToggleButton onClick={toggle} isActive={isActive} disabled={disabled}/>
        </div>
    )
}