function ToggleButton({className, onClick, isActive, disabled}) {
    return (
        <button
            type='button'
            className={`lbaic-settings-toggle${className ? ' ' + className : ''}${isActive ? ' active' : ''}${disabled ? ' lbaic-settings-button-disabled' : ''}`}
            onClick={(e) => !disabled && onClick(e)}
            tabIndex='-1'>
            <i className='lbaic-settings-toggle-in'/>
        </button>
    )
}

export default ToggleButton;