import {useId} from "@wordpress/element";

export default function Textarea({value, setValue, className, placeholder, staticPlaceholder, isReverse, disabled, validate, errorMessage, textareaProps = {}, placeholderChildren}) {
    const fieldId = useId();

    /**
     * Update value
     *
     * @param {Event} e Event
     */
    const updateValue = (e) => {
        setValue(e.target.value);
        // Validate
        if (typeof validate === 'function') {
            validate(e.target.value);
        }
    }

    return (
        <div
            className={`lbaic-settings-textarea-holder${className ? ' ' + className : ''}${isReverse ? ' lbaic-settings-textarea-reverse' : ''}${disabled ? ' lbaic-settings-textarea-disabled' : ''}${errorMessage ? ' lbaic-settings-textarea-error' : ''}`}
        >
            {placeholder?.length > 0 && (
                <div className="lbaic-settings-textarea-placeholder">
                    <label
                        htmlFor={fieldId}
                        className="lbaic-settings-textarea-placeholder-in"
                    >{placeholder}</label>
                    {placeholderChildren}
                </div>
            )}
            <div className='lbaic-settings-textarea-holder-in'>
                <textarea
                    id={fieldId}
                    className='lbaic-settings-textarea'
                    value={value}
                    onChange={updateValue}
                    placeholder={staticPlaceholder}
                    {...textareaProps}
                />
            </div>
            {errorMessage && (
                <div className='lbaic-settings-textarea-error-message'>
                    <p className='lbaic-settings-textarea-error-message-in'>{errorMessage}</p>
                </div>
            )}
        </div>
    );
}