export default function TagVar({label, icon, image, link, imageClassName, withoutRemove, onClick, className}) {
    return (
        <div
            className={`lbaic-settings-tag lbaic-settings-tag-h-24 lbaic-settings-tag-pi-8 ${className ? className : ''}`}>
            {!!icon &&
                <svg className='lbaic-settings-tag-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href={`#lbaic-settings-${icon}`}/>
                </svg>}
            {!!image && (
                <img className={`lbaic-settings-tag-img${imageClassName ? ' ' + imageClassName : ''}`} src={image}
                     alt={label}/>
            )}
            {link ? (
                <a href={link} className='lbaic-settings-tag-link' target='_blank' rel='noreferrer'>
                    <span className='lbaic-settings-tag-label' dangerouslySetInnerHTML={{__html: label}}/>
                    <svg
                        className="lbaic-settings-tag-link-i"
                        xmlns="http://www.w3.org/2000/svg"
                        fill="none"
                        viewBox="0 0 24 24"
                    >
                        <use href="#lbaic-settings-external-arrow" className="lbaic-settings-external-arrow"></use>
                        <use href="#lbaic-external-box"></use>
                    </svg>
                </a>
            ) : (
                <span className='lbaic-settings-tag-label' dangerouslySetInnerHTML={{__html: label}}/>
            )}
            {!withoutRemove &&
                <button type='button' className='lbaic-settings-tag-remove lbaic-settings-button-reset'
                        onClick={(e) => {
                            e.stopPropagation();
                            if (typeof onClick === 'function') {
                                onClick();
                            }
                        }}>
                    <svg className='lbaic-settings-tag-remove-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                         viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-close'/>
                    </svg>
                </button>}
        </div>
    )
}