import {getFileFormatedSize} from "../../../../../../../../../helpers";
import Chip from "../../../../../../chip";
import RealTimeRelativeTime from "../../../../../../real-time-relative-time";
import Tooltip from "../../../../../../tooltip";

export default function FileRow({file, actions}) {
    const errors = file.metadata?.errors?.length > 0 ?
        file.metadata.errors.map(item => __(item.message, 'limb-chatbot'))
        :
        null;

    return <tr className='lbaic-settings-e-anf-table-body-in'>
        <td className='lbaic-settings-e-anf-table-body-item lbaic-settings-e-anf-table-body-file'>
            <span className='lbaic-settings-e-anf-table-body-label lbaic-settings-e-anf-table-body-file-label'>{file.original_name}</span>
        </td>
        <td className='lbaic-settings-e-anf-table-body-item'>
            <span className='lbaic-settings-e-anf-table-body-label lbaic-settings-e-anf-table-body-file-label'>{getFileFormatedSize(file.file_size || 0)}</span>
        </td>
        <td className='lbaic-settings-e-anf-table-body-item'>
            <Chip>
                <RealTimeRelativeTime
                    dateString={file.created_at}
                    className='lbaic-settings-chip-label' // lbaic-settings-e-anf-table-body-label lbaic-settings-e-anf-table-body-file-label
                />
            </Chip>
        </td>
        <td className='lbaic-settings-e-anf-table-body-item lbaic-settings-e-anf-table-body-remove'>
            <div className="lbaic-settings-e-anf-table-body-item-in">
                {errors?.length > 0 && (
                    <Tooltip label={errors.join('<br/>')}>
                        <svg className='lbaic-settings-tooltip-i lbaic-settings-error-i' xmlns='http://www.w3.org/2000/svg'
                             fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-error'/>
                        </svg>
                    </Tooltip>
                )}
                {actions}
            </div>
        </td>
    </tr>
}