import {useSortable} from '@dnd-kit/sortable';
import {CSS} from '@dnd-kit/utilities';

export default function SortableItem({text, remove}) {
    const {
        attributes,
        listeners,
        setNodeRef,
        transform,
        transition,
    } = useSortable({id: text});

    const style = {
        transform: CSS.Transform.toString(transform),
        transition,
    };

    return (
        <div ref={setNodeRef} style={style} className='lbaic-settings-cb-qs-draggable'>
            <button type='button'
                    className='lbaic-settings-cb-qs-draggable-holder lbaic-settings-button-reset' {...listeners} {...attributes}>
                <svg className='lbaic-settings-cb-qs-draggable-holder-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-drag-indicator'/>
                </svg>
            </button>
            <div className='lbaic-settings-cb-qs-draggable-row'>
                <div className='lbaic-settings-cb-qs-question'>
                    <span className='lbaic-settings-cb-qs-question-label'>{text}</span>
                </div>
            </div>
            <button type='button'
                    className='lbaic-settings-cb-qs-draggable-remove lbaic-settings-button-reset' onClick={() => remove(text)}>
                <svg className='lbaic-settings-cb-qs-draggable-remove-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-close'/>
                </svg>
            </button>
        </div>
    )
}