import {useEffect, useState} from "@wordpress/element";

export function RangeSlider({value, setValue, min, max, step = 1}) {
    const [percent, setPercent] = useState(0);

    useEffect(() => {
        setPercent(((value - min) / (max - min)) * 100);
    }, [value, min, max]);

    return (
        <div className='lbaic-settings-range' style={{'--lbaic-settings-range-value': percent + '%'}}>
            <input type='range'
                   className='lbaic-settings-range-input'
                   value={value}
                   min={min}
                   max={max}
                   step={step}
                   onChange={e => {
                       setValue(+e.target.value);
                   }}
            />
        </div>
    )
}

export default function Range({label, value, setValue, className, min, max, step = 1, children}) {
    return (
        <div className={`lbaic-settings-range-holder${className ? ' ' + className : ''}`}>
            <div className="lbaic-settings-range-header">
                <div className="lbaic-settings-range-header-in">
                    <div className="lbaic-settings-range-header-label">
                        <label className="lbaic-settings-range-header-label-in">{label}</label>
                        {children}
                    </div>
                    <span className='lbaic-settings-range-header-value'>
                        {value}/{max}
                    </span>
                </div>
            </div>
            <div className='lbaic-settings-range-wrapper'>
                <RangeSlider
                    value={value}
                    setValue={setValue}
                    min={min}
                    max={max}
                    step={step}
                />
            </div>
        </div>
    )
}