import {useEffect, useState} from "@wordpress/element";

export default function ExpandableContainer({containerRef, label, children, open}) {
    const [isOpened, setIsOpened] = useState(false);

    useEffect(() => {
        if (open) {
            setIsOpened(true);
        }
    }, [open]);

    return (
        <div
            ref={containerRef}
            className={`lbaic-settings-exp-container${isOpened ? ' opened' : ''}`}
        >
            <div className='lbaic-settings-exp-header'>
                <div className='lbaic-settings-exp-header-in'>
                    <button type='button'
                            className='lbaic-settings-exp-header-action lbaic-settings-button-reset' onClick={() => setIsOpened(!isOpened)}>
                        <span className='lbaic-settings-exp-header-label'>{label}</span>
                        <svg className='lbaic-settings-exp-header-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                             viewBox='0 0 24 24'>
                            <use href='#lbaic-settings-more-arrow'/>
                        </svg>
                    </button>
                </div>
            </div>
            <div className='lbaic-settings-exp-body'>
                <div className='lbaic-settings-exp-body-in'>
                    {children}
                </div>
            </div>
        </div>
    )
}