import {__} from "@wordpress/i18n";

export default function CostToken({type, setType}) {
    return <div className="lbaic-settings-cb-cl-ct-toggle">
        <div className="lbaic-settings-cb-cl-ct-toggle-h-42 lbaic-settings-cb-cl-ct-toggle-in">
            <div className={`lbaic-settings-cb-cl-ct-toggle-tab${type === 'cost' ? ' active' : ''}`}>
                <button type='button'
                        className="lbaic-settings-cb-cl-ct-toggle-tab-in lbaic-settings-button-reset" onClick={() => setType('cost')}>
                    <svg className="lbaic-settings-cb-cl-ct-icon" xmlns="http://www.w3.org/2000/svg"
                         viewBox="0 0 24 24">
                        <use href="#lbaic-settings-attach-money"></use>
                    </svg>
                    <div className="lbaic-settings-cb-cl-ct-desc">
                        <h4 className="lbaic-settings-cb-cl-ct-desc-in">{__("Cost", 'limb-chatbot')}</h4>
                    </div>
                </button>
            </div>
            <div className={`lbaic-settings-cb-cl-ct-toggle-tab${type === 'token' ? ' active' : ''}`}>
                <button type='button'
                        className="lbaic-settings-cb-cl-ct-toggle-tab-in lbaic-settings-button-reset" onClick={() => setType('token')}>
                    <svg className="lbaic-settings-cb-cl-ct-icon" xmlns="http://www.w3.org/2000/svg"
                         viewBox="0 0 24 24">
                        <use href="#lbaic-settings-match-case"></use>
                    </svg>
                    <div className="lbaic-settings-cb-cl-ct-desc">
                        <h4 className="lbaic-settings-cb-cl-ct-desc-in">{__("Token", 'limb-chatbot')}</h4>
                    </div>
                </button>
            </div>
        </div>
    </div>
}