import {__} from "@wordpress/i18n";

export default function Chip({label, iconName, className, children}) {
    return <div className={`lbaic-settings-chip${className ? ' ' + className : ''}`}>
        {iconName &&
            <svg className='lbaic-settings-chip-i' xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                <use href={`#lbaic-settings-${iconName}`}/>
            </svg>}
        {children}
        {!children && (
            <span
                className={`lbaic-settings-chip-label${!label ? ' lbaic-settings-chip-label-null' : ''}`}>{label || __('N/A', 'limb-chatbot')}</span>
        )}
    </div>
}