export default function Checkbox({
                                     label,
                                     icon,
                                     image,
                                     imageClassName,
                                     desc,
                                     id,
                                     isChecked,
                                     isIntermediateChecked,
                                     toggleValue,
                                     disabled,
                                     hideCheckbox,
                                     className
                                 }) {
    const handleChange = (e) => {
        if (!disabled) {
            toggleValue();
        }
    }

    let dynamicClassName = '';
    if (isIntermediateChecked) {
        dynamicClassName += ' checked-intermediate';
    }
    if (isChecked) {
        dynamicClassName += ' checked';
    }
    if (disabled) {
        dynamicClassName += ' disabled';
    }

    return (
        <div className={`lbaic-settings-checkbox-wrapper${className ? ' ' + className : ''}`}>
            <label
                className={`lbaic-settings-checkbox${dynamicClassName}`}
                htmlFor={id}
                onChange={handleChange}
            >
                {!hideCheckbox &&
                    <>
                        <input id={id} type='checkbox' className='lbaic-settings-checkbox-input'/>
                        <i className='lbaic-settings-checkbox-in'>
                            <svg className='lbaic-settings-checkbox-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                                 viewBox='0 0 24 24'>
                                <use className='lbaic-settings-checkbox-i-check' href='#lbaic-settings-checkbox-check'/>
                                <use className='lbaic-settings-checkbox-i-check-intermediate'
                                     href='#lbaic-settings-checkbox-check-intermediate'/>
                            </svg>
                        </i>
                        {Boolean(icon) &&
                            <svg className='lbaic-settings-checkbox-icon' xmlns='http://www.w3.org/2000/svg' fill='none'
                                 viewBox='0 0 24 24'>
                                <use href={`#lbaic-settings-${icon}`}/>
                            </svg>}
                        {Boolean(image) && (
                            <img className={`lbaic-settings-checkbox-img${imageClassName ? ' ' + imageClassName : ''}`}
                                 src={image} alt={label}/>
                        )}
                    </>}
                {label?.length > 0 &&
                    <span className='lbaic-settings-checkbox-label' dangerouslySetInnerHTML={{__html: label}}/>}
            </label>
            {desc?.length > 0 && (
                <div className='lbaic-settings-checkbox-desc'>
                    <p className='lbaic-settings-checkbox-desc-in'>{desc}</p>
                </div>
            )}
        </div>
    )
}