export default function Badge({label, isSmall, icon, className, custom}) {
    const _className = custom ? (
        className
    ) : (
        `lbaic-settings-badge-h-${isSmall ? '21' : '25'} lbaic-settings-badge-pi-${isSmall ? '8' : '12'}${className ? ' ' + className : ''}`
    );

    return (
        <div
            className={`lbaic-settings-badge${_className ? ' ' + _className : ''}`}>
            {icon?.length > 0 && (
                <svg className='lbaic-settings-badge-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                     viewBox='0 0 24 24'>
                    <use href={`#lbaic-settings-${icon}`}/>
                </svg>
            )}
            {label !== undefined && (
                <span className='lbaic-settings-badge-label'>{label}</span>
            )}
        </div>
    )
}