import {__} from "@wordpress/i18n";
import {isNumeric, mathFloor} from "../../../../components/chatbots/includes/helpers";

export default function ButtonPlayPause({
                                            type = 'primary',
                                            label,
                                            icon,
                                            playing,
                                            paused,
                                            progress,
                                            play,
                                            pause,
                                            disabled,
                                            className
                                        }) {
    const isPause = playing && isNumeric(progress);

    const handleClick = (e) => {
        if (disabled) {
            return;
        }
        // Play/Pause
        if (isPause) {
            pause();
        } else {
            play();
        }
    }

    return <button type='button'
                   onClick={handleClick}
                   className={`lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-${type}${className ? ' ' + className : ''}${disabled ? ' lbaic-settings-button-disabled' : ''}`}>
        {playing ? (
            isPause ? (
                <div className='lbaic-settings-button-save-process'>
                    <svg className='lbaic-settings-button-i lbaic-settings-loading-circle lbaic-settings-button-loading-circle'
                         xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'
                         style={{
                             '--lbaic-settings-button-loading-circle-progress': progress
                         }}>
                        <use href='#lbaic-settings-circle'/>
                    </svg>
                    <svg className='lbaic-settings-button-i lbaic-settings-button-save-process-i'
                         xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                        <use href='#lbaic-settings-pause'/>
                    </svg>
                </div>
            ) : (
                <svg className='lbaic-settings-button-i lbaic-settings-loading-circle lbaic-settings-button-loading-circle'
                     xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-circle'/>
                </svg>
            )
        ) : (
            <svg className='lbaic-settings-button-i' xmlns='http://www.w3.org/2000/svg' fill='none'
                 viewBox='0 0 24 24'>
                <use href={`#lbaic-settings-${icon}`}/>
            </svg>
        )}
        {(playing || paused) && (
            <span className='lbaic-settings-button-process-progress'>{mathFloor(progress)}%</span>
        )}
        <span className='lbaic-settings-button-label'>{isPause ? __("Pause", 'limb-chatbot') : label}</span>
    </button>
}