export const COPILOT_MENU = {
    width: 120,
    height: 180,
}

const INSTRUCTIONS =
    "\n\n**CRITICAL INSTRUCTIONS - READ CAREFULLY:**" +
    "\n- **RESPOND IN THE SAME LANGUAGE** as the input text provided." +
    "\n- **OUTPUT FORMAT: MARKDOWN** - If the result contains HTML tags, convert them to markdown syntax." +
    "\n- Output **ONLY** the processed text itself, absolutely nothing else." +
    "\n- **NO CONVERSATIONAL TEXT** anywhere in your response." +
    "\n- **NO COMMENTARY** or meta-discussion about the text." +
    "\n- **YOUR ENTIRE RESPONSE** must be the result text and nothing more.";

export const PROMPTS = {
    'revise': {
        'before': "Edit this text for grammar, punctuation, and overall readability, while keeping its meaning: ",
        'after': INSTRUCTIONS
    },
    'shorter': {
        'before': "Shorten this text by removing approximately 2-4 words while preserving its original meaning and clarity: ",
        'after': INSTRUCTIONS
    },
    'longer': {
        'before': "Expand this text by adding ~4 words to include slight additional detail while preserving its original meaning: ",
        'after': INSTRUCTIONS
    },
    'custom': {
        'before': "",
        'after':
            "\n\n**CRITICAL INSTRUCTIONS - READ CAREFULLY:**" +
            "\n- **LANGUAGE:** If the instruction specifies a language, use that language. Otherwise, use the same language as the instruction itself." +
            "\n- **OUTPUT FORMAT: MARKDOWN** - If the result contains HTML tags, convert them to markdown syntax." +
            "\n- Output **ONLY** the requested result itself, absolutely nothing else." +
            "\n- **NO CONVERSATIONAL TEXT** anywhere in your response." +
            "\n- **NO COMMENTARY**, explanations, or meta-discussion about the content." +
            "\n- **NO EXTRA CONTEXT** or teaching moments - just the pure result." +
            "\n- **YOUR ENTIRE RESPONSE** must be the requested content and nothing more."
    },
};