import {isNumeric, mathFloor} from "../../../../components/chatbots/includes/helpers";

export default function Button({
                                   type = 'primary',
                                   label,
                                   icon,
                                   onClick,
                                   loading,
                                   progress,
                                   disabled,
                                   className
                               }) {
    return <button type='button'
                   onClick={() => !disabled && onClick()}
                   className={`lbaic-settings-button lbaic-settings-button-center lbaic-settings-button-h-40 lbaic-settings-button-${type}${className ? ' ' + className : ''}${disabled ? ' lbaic-settings-button-disabled' : ''}`}>
        {loading ? (
            <>
                <svg className='lbaic-settings-button-i lbaic-settings-loading-circle lbaic-settings-button-loading-circle'
                     xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                    <use href='#lbaic-settings-circle'/>
                </svg>
                {isNumeric(progress) && (
                    <span className='lbaic-settings-button-process-progress'>{mathFloor(progress)}%</span>
                )}
            </>
        ) : (
            icon && (
                <svg className='lbaic-settings-button-i' xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24'>
                    <use href={`#lbaic-settings-${icon}`}/>
                </svg>
            )
        )}
        <span className='lbaic-settings-button-label'>{label}</span>
    </button>
}