<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://wplikedislike.pro
 * @since      1.0.0
 *
 * @package    Likedislike_For_Wp
 * @subpackage Likedislike_For_Wp/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Likedislike_For_Wp
 * @subpackage Likedislike_For_Wp/includes
 * @author     Ankit Panchal <wptoolsdev@gmail.com>
 */
class Likedislike_For_Wp_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'like-dislike-for-wp-pro',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
