<?php
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) { exit(); }

delete_option( 'lwpopt_settings' );

$upload    = wp_upload_dir();
$cache_dir = trailingslashit( $upload['basedir'] ) . 'lwpopt-cache/';

if ( is_dir( $cache_dir ) ) {
    foreach ( glob( $cache_dir . '*', GLOB_MARK ) as $file ) {
        if ( is_file( $file ) ) {
            wp_delete_file( $file ); // ✅ safer than unlink()
        }
    }

    // ✅ Use WP_Filesystem to remove directory
    if ( ! function_exists( 'WP_Filesystem' ) ) {
        require_once ABSPATH . 'wp-admin/includes/file.php';
    }

    global $wp_filesystem;
    WP_Filesystem();

    if ( $wp_filesystem->is_dir( $cache_dir ) ) {
        $wp_filesystem->rmdir( $cache_dir, true ); // true = recursive
    }
}
