<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Return plugin settings with defaults.
 */
function lwpopt_get_settings() {
    $defaults = array(
        'enable_cache' => 1,
        'enable_lazyload' => 1,
        'heartbeat' => 60,
    );
    return wp_parse_args( get_option( 'lwpopt_settings', array() ), $defaults );
}

/**
 * Return writable cache dir inside uploads directory.
 */
function lwpopt_get_cache_dir() {
    $upload = wp_upload_dir();
    $dir = trailingslashit( $upload['basedir'] ) . 'lwpopt-cache/';
    if ( ! file_exists( $dir ) ) {
        wp_mkdir_p( $dir );
    }
    return $dir;
}
