<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LWPOpt_LazyLoad {
    public static function init() {
        $opts = lwpopt_get_settings();
        if ( ! empty( $opts['enable_lazyload'] ) ) {
            add_filter( 'wp_get_attachment_image_attributes', array( __CLASS__, 'add_lazy_attribute' ), 10, 3 );
            add_filter( 'the_content', array( __CLASS__, 'filter_content_images' ), 999 );
        }
    }

    public static function add_lazy_attribute( $attr, $attachment, $size ) {
        if ( empty( $attr['loading'] ) ) {
            $attr['loading'] = 'lazy';
        }
        return $attr;
    }

    public static function filter_content_images( $content ) {
        if ( stripos( $content, '<img' ) === false ) return $content;
        // Add loading="lazy" only if not present and not marked with class no-lazy
        $content = preg_replace_callback( '#<img([^>]+)>#i', function( $m ) {
            $tag = $m[0];
            if ( stripos( $tag, 'loading=' ) !== false ) return $tag;
            if ( stripos( $tag, 'class="no-lazy"' ) !== false ) return $tag;
            $new = rtrim( $tag, '>' );
            $new .= ' loading="lazy">';
            return $new;
        }, $content );
        return $content;
    }
}
