<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LWPOpt_Heartbeat {
    public static function init() {
        add_filter( 'heartbeat_settings', array( __CLASS__, 'modify' ) );
        add_action( 'init', array( __CLASS__, 'maybe_deregister' ) );
    }

    public static function modify( $settings ) {
        $opts = lwpopt_get_settings();
        $settings['interval'] = isset( $opts['heartbeat'] ) ? intval( $opts['heartbeat'] ) : 60;
        return $settings;
    }

    public static function maybe_deregister() {
        $opts = lwpopt_get_settings();
        if ( isset( $opts['heartbeat'] ) && intval( $opts['heartbeat'] ) === 0 ) {
            // remove heartbeat script on frontend for performance if disabled
            if ( ! is_admin() ) {
                wp_deregister_script( 'heartbeat' );
            }
        }
    }
}
