<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LWPOpt_Functions {
    public static function init() {
        add_action( 'admin_post_lwpopt_clear_cache', array( __CLASS__, 'handle_clear_cache' ) );
        add_action( 'admin_notices', array( __CLASS__, 'cache_notice' ) );
    }

    public static function handle_clear_cache() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'Unauthorized', 'lightweight-performance-optimizer' ) );
        }

        // Verify nonce safely
        if ( ! isset( $_POST['_lwpopt_clear_cache_nonce'] ) ||
            ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_lwpopt_clear_cache_nonce'] ) ), 'lwpopt_clear_cache' ) ) {
            wp_die( esc_html__( 'Security check failed.', 'lightweight-performance-optimizer' ) );
        }

        // Clear cache via class if available (uses wp_delete_file internally)
        if ( class_exists( 'LWPOpt_Cache' ) && method_exists( 'LWPOpt_Cache', 'clear_cache' ) ) {
            LWPOpt_Cache::clear_cache();
        } else {
            $dir = lwpopt_get_cache_dir();
            if ( is_dir( $dir ) ) {
                foreach ( glob( $dir . '*', GLOB_MARK ) as $file ) {
                    if ( is_file( $file ) ) {
                        wp_delete_file( $file );
                    }
                }
            }
        }

        // Set a short transient (site-specific) to show the admin notice after redirect.
        // Keep it short-lived (30 seconds).
        set_transient( 'lwpopt_cache_cleared', '1', 30 );

        // Redirect back to the referring page (no query args).
        $redirect = wp_get_referer() ? wp_get_referer() : admin_url( 'options-general.php?page=lwpopt-settings' );
        wp_safe_redirect( $redirect );
        exit;
    }

    public static function cache_notice() {
        // Use transient instead of $_GET. Safe — no nonce needed here.
        $status = get_transient( 'lwpopt_cache_cleared' );
        if ( $status ) {
            // remove transient immediately so notice shows only once
            delete_transient( 'lwpopt_cache_cleared' );

            printf(
                '<div class="notice notice-success is-dismissible"><p>%s</p></div>',
                esc_html__( 'Cache cleared successfully!', 'lightweight-performance-optimizer' )
            );
        }
    }
}
