<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LWPOpt_Cache {
    public static function init() {
        add_action( 'save_post', array( __CLASS__, 'clear_cache' ) );
    }

    public static function clear_cache() {
        $dir = lwpopt_get_cache_dir();
        if ( is_dir( $dir ) ) {
            foreach ( glob( $dir . '*', GLOB_MARK ) as $file ) {
                if ( is_file( $file ) ) {
                    wp_delete_file( $file ); // ✅ Use WordPress API
                }
            }
        }
    }
}
