<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LWPOpt_Admin {
    public static function init() {
        add_action( 'admin_menu', array( __CLASS__, 'menu' ) );
        add_action( 'admin_init', array( __CLASS__, 'register' ) );
    }

    public static function menu() {
        add_options_page( esc_html__( 'Performance Optimizer', 'lightweight-performance-optimizer' ), esc_html__( 'Performance Optimizer', 'lightweight-performance-optimizer' ), 'manage_options', 'lwpopt-settings', array( __CLASS__, 'settings_page' ) );
    }

    public static function register() {
        register_setting(
            'lwpopt_settings_group',
            'lwpopt_settings',
            array( __CLASS__, 'sanitize_settings' )
        );
    }

    public static function sanitize_settings( $input ) {
        $output = array();
        $output['enable_cache']    = ! empty( $input['enable_cache'] ) ? 1 : 0;
        $output['enable_lazyload'] = ! empty( $input['enable_lazyload'] ) ? 1 : 0;
        $output['heartbeat']       = isset( $input['heartbeat'] ) ? absint( $input['heartbeat'] ) : 60;
        return $output;
    }

    public static function settings_page() {
        $opts = lwpopt_get_settings();
        ?>
        <div class="wrap">
            <h1><?php esc_html_e( 'Lightweight Performance Optimizer', 'lightweight-performance-optimizer' ); ?></h1>

            <form method="post" action="options.php">
                <?php settings_fields( 'lwpopt_settings_group' ); ?>
                <table class="form-table">
                    <tr>
                        <th><?php esc_html_e( 'Enable Cache', 'lightweight-performance-optimizer' ); ?></th>
                        <td><input type="checkbox" name="lwpopt_settings[enable_cache]" value="1" <?php checked( $opts['enable_cache'], 1 ); ?>></td>
                    </tr>
                    <tr>
                        <th><?php esc_html_e( 'Enable Lazy Load', 'lightweight-performance-optimizer' ); ?></th>
                        <td><input type="checkbox" name="lwpopt_settings[enable_lazyload]" value="1" <?php checked( $opts['enable_lazyload'], 1 ); ?>></td>
                    </tr>
                    <tr>
                        <th><?php esc_html_e( 'Heartbeat Interval', 'lightweight-performance-optimizer' ); ?></th>
                        <td>
                            <select name="lwpopt_settings[heartbeat]">
                                <option value="0" <?php selected( $opts['heartbeat'], 0 ); ?>><?php esc_html_e( 'Disabled', 'lightweight-performance-optimizer' ); ?></option>
                                <option value="15" <?php selected( $opts['heartbeat'], 15 ); ?>>15s</option>
                                <option value="30" <?php selected( $opts['heartbeat'], 30 ); ?>>30s</option>
                                <option value="60" <?php selected( $opts['heartbeat'], 60 ); ?>>60s</option>
                            </select>
                            <p class="description"><?php esc_html_e( 'Choose how often WordPress sends heartbeat requests.', 'lightweight-performance-optimizer' ); ?></p>
                        </td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>

            <h2><?php esc_html_e( 'Cache Management', 'lightweight-performance-optimizer' ); ?></h2>

            <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
                <?php wp_nonce_field( 'lwpopt_clear_cache', '_lwpopt_clear_cache_nonce' ); ?>
                <input type="hidden" name="action" value="lwpopt_clear_cache" />
                <?php submit_button( esc_html__( 'Clear Cache', 'lightweight-performance-optimizer' ), 'secondary', 'lwpopt_clear_cache' ); ?>
            </form>

        </div>
        <?php
    }
}
