<?php
/**
 * LightSync Pro - Uninstall Handler
 * 
 * IMPORTANT: This file intentionally does NOT delete user data.
 * 
 * Mappings between cloud assets (Lightroom, Figma, Canva, Dropbox) and 
 * WordPress attachments MUST persist even if the plugin is removed.
 * 
 * Deleting this data would cause:
 * - Duplicate imports on reinstall (same cloud assets imported again)
 * - Orphaned media (no way to track which attachments came from which source)
 * - Loss of sync history and checksums
 * 
 * If a user truly wants to wipe all data, they can:
 * 1. Enable "Delete all data on deactivate" in Settings before deactivating
 * 2. Use the "Reset All Data" button in Settings (if implemented)
 * 3. Manually delete via database
 * 
 * Data preserved on uninstall:
 * - wp_postmeta: _lightsync_* meta on attachments
 * - wp_options: lightsync_asset_map
 * 
 * @package LightSyncPro
 */

// Security check - only run during actual uninstall
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Intentionally empty - all mapping data is preserved
// This file exists to prevent WordPress from running any default cleanup
// and to document why we don't delete data on uninstall
