<?php
namespace LightSyncPro\Util;

if (!defined('ABSPATH')) exit;

class Adobe {
    public static function strip_prefix($body){
        if (!is_string($body)) return $body;
        // Typical prefixes: "while (1) {}", "while(1){}", possibly with spaces/newlines
        $trim = ltrim($body);
        if (strpos($trim, 'while') === 0) {
            // Remove up to first '{' '}' pair + whitespace
            $trim = preg_replace('/^while\s*\(\s*1\s*\)\s*\{\s*\}\s*/', '', $trim);
        }
        return $trim;
    }
    public static function decode($body){
        $clean = self::strip_prefix($body);
        $json = json_decode($clean, true);
        return is_array($json) ? $json : null;
    }
}
