<?php
namespace LightSyncPro\Compress;

if ( ! defined('ABSPATH') ) exit;

class AvifPhp {
    public static function is_supported() : bool {
        if ( class_exists('Imagick') ) {
            try {
                $im = new \Imagick();
                $fmts = array_map('strtoupper', $im->queryFormats());
                if (in_array('AVIF', $fmts, true)) return true;
            } catch (\Throwable $e) {}
        }
        return function_exists('imageavif');
    }

    public static function engine_label() : string {
        if ( class_exists('Imagick') ) {
            try {
                $im = new \Imagick();
                $fmts = array_map('strtoupper', $im->queryFormats());
                if (in_array('AVIF', $fmts, true)) return 'Imagick';
            } catch (\Throwable $e) {}
        }
        return function_exists('imageavif') ? 'GD' : 'none';
    }

    public static function encode($src, $dst, int $quality = 60) : bool {
        $q = max(0, min(100, $quality));

        if ( class_exists('Imagick') ) {
            try {
                $im = new \Imagick();
                $im->setOption('heic:speed', '6');
                $im->readImage($src);
                $im->autoOrient();
                $im->stripImage();
                $im->setImageCompressionQuality($q);
                $im->setImageFormat('AVIF');
                $ok = $im->writeImage($dst);
                $im->destroy();
                if ($ok && file_exists($dst)) return true;
            } catch (\Throwable $e) { }
        }

        if ( function_exists('imageavif') ) {
            if ( ! function_exists('wp_get_image_editor') ) return false;
            $ed = wp_get_image_editor($src);
            if ( is_wp_error($ed) ) return false;
            if ( method_exists($ed, 'set_mime_type') ) $ed->set_mime_type('image/avif');
            add_filter('wp_editor_set_quality', function($qual,$mime) use ($q){
                return $mime==='image/avif' ? $q : $qual;
            }, 10, 2);
            $saved = $ed->save($dst, 'image/avif');
            return !is_wp_error($saved) && !empty($saved['path']);
        }
        return false;
    }
}
