<?php
namespace LightSyncPro;

if ( ! defined('ABSPATH') ) exit;

use LightSyncPro\Compress\AvifPhp;

class LightSync_Compress {
    public static function convert_to_avif($src_path, $quality = 70) {
        if ( ! class_exists('LightSyncPro\\Compress\\AvifPhp') ) {
            require_once __DIR__ . '/compress/class-avif-php.php';
        }
        
        // Check if AVIF is enabled in LightSync Pro settings
        $enabled = (int) \LightSyncPro\Admin\Admin::get_opt('avif_enable', 1);
        if ( ! $enabled ) return false;

        $dst_path = preg_replace('/\.[a-zA-Z0-9]+$/', '.avif', $src_path);
        $engine   = AvifPhp::engine_label();

        if ( ! AvifPhp::is_supported() ) {
            Logger::debug("LightSync Pro: AVIF not supported by PHP engine ({$engine}).");
            return false;
        }
        $ok = AvifPhp::encode($src_path, $dst_path, (int)$quality);
        if ( $ok && file_exists($dst_path) ) {
            return [
                'ok'        => true,
                'engine'    => $engine,
                'src'       => $src_path,
                'dst'       => $dst_path,
                'bytes_in'  => @filesize($src_path) ?: 0,
                'bytes_out' => @filesize($dst_path) ?: 0,
            ];
        }
        return ['ok' => false, 'engine' => $engine];
    }
}
