<?php
namespace LightSyncPro\Util;

use LightSyncPro\Admin\Admin;


class Notify {

    public static function enabled(){
        // Only when license is active
        if ( ! false ) return false;
        $o = Admin::get_opt();
        return !empty($o['slack_webhook']) || !empty($o['notify_email']);
    }

    public static function send($subject, $message){
        $o = Admin::get_opt();
        $sent = false;

        // Email
        if ( !empty($o['notify_email']) ){
            $to = array_map('trim', explode(',', $o['notify_email']));
            $headers = [ 'Content-Type: text/plain; charset=UTF-8' ];
            if ( function_exists('wp_mail') ){
                $sent = wp_mail($to, $subject, $message, $headers) || $sent;
            }
        }

        // Slack webhook
        if ( !empty($o['slack_webhook']) ){
           $payload = [ 'text' => '*'.$subject."*\n".$message ];
            $resp = wp_remote_post($o['slack_webhook'], [
                'headers' => ['Content-Type'=>'application/json'],
                'body'    => wp_json_encode(['text' => "*{$subject}*\n{$message}"]),
                'timeout' => 10
            ]);
            if ( ! is_wp_error($resp) ){
                $sent = true;
            }
        }
        return $sent;
    }
}
