<?php
namespace LightSyncPro\Util;
if ( ! defined('ABSPATH') ) exit;
/**
 * Lightweight debug logger for LightSync Pro.
 * Replaces direct error_log() calls so WP CodeSniffer doesn't complain.
 *
 * Logging only runs if:
 *   1) WP_DEBUG is true, OR
 *   2) The filter 'lightsyncpro_debug' returns true.
 */
class Logger {
    /**
     * Write a debug message.
     *
     * @param string $msg
     */
    public static function debug( $msg ) : void {
        // Allow dev override: add_filter('lightsyncpro_debug', '__return_true');
        $enabled = apply_filters( 'lightsyncpro_debug', defined( 'WP_DEBUG' ) && WP_DEBUG );
        if ( ! $enabled ) {
            return; // Silent in production
        }
        // Prefix logs for easy searching
        $line = '[LightSyncPro] ' . trim( $msg );
        // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
        error_log( $line );
    }
}