<?php
namespace LightSyncPro\Util;
if (!defined('ABSPATH')) exit;

/**
 * Small helpers for dealing with Adobe LR API responses.
 */
class Adobe {

    /**
     * Strip Adobe's JSON prefix like "while (1) {} " and decode.
     * @param string $body Raw HTTP body
     * @param bool $assoc return associative array
     * @return array|object|null
     */
    public static function decode($body, $assoc = true) {
        if (!is_string($body) || $body === '') return $assoc ? [] : (object)[];
        // Some endpoints prefix:  while (1) {} <json>
        $prefixes = [
            'while (1) {}',
            'while(1){}',
            "while (1) {}\n",
            "while(1){}\n",
        ];
        $trimmed = ltrim($body);
        foreach ($prefixes as $p) {
            if (strpos($trimmed, $p) === 0) {
                $trimmed = ltrim(substr($trimmed, strlen($p)));
                break;
            }
        }
        $data = json_decode($trimmed, $assoc);
        // If decode fails, return a minimal error envelope so callers can WP_Error gracefully
        if (json_last_error() !== JSON_ERROR_NONE) {
            return $assoc ? ['_decode_error' => json_last_error_msg(), '_raw' => $body] : (object)[ '_decode_error' => json_last_error_msg(), '_raw' => $body ];
        }
        return $data;
    }
}
