(function(){
  function ensureOverlay(){
    var el = document.querySelector('.lsp-lightbox');
    if (el) return el;
    el = document.createElement('div');
    el.className = 'lsp-lightbox';
    el.innerHTML = '<span class="lsp-close" aria-label="Close">×</span><img alt=""><div class="lsp-cap"></div>';
    document.body.appendChild(el);
    el.addEventListener('click', function(e){
      if (e.target.classList.contains('lsp-close') || e.target === el){ el.classList.remove('open'); }
    });
    document.addEventListener('keydown', function(e){ if (e.key==='Escape') el.classList.remove('open'); });
    return el;
  }
  function delegate(){
    document.body.addEventListener('click', function(e){
      var a = e.target.closest && e.target.closest('a.lsp-lightbox-link[data-lsp="1"]');
      if (!a) return;
      e.preventDefault();
      var overlay = ensureOverlay();
      var img = overlay.querySelector('img');
      var cap = overlay.querySelector('.lsp-cap');
      img.src = a.getAttribute('href');
      cap.textContent = a.getAttribute('title') || (a.querySelector('img') && a.querySelector('img').getAttribute('alt')) || '';
      overlay.classList.add('open');
    });
  }
  if (document.readyState === 'loading'){
    document.addEventListener('DOMContentLoaded', delegate);
  } else {
    delegate();
  }
})();
