<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly
?>
<div class="p-4 relative mx-auto block">
    <div class="flex place-items-center">
        <div class="flex flex-auto place-items-center gap-3">

            <h1>
                <img  class="inline mr-2" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/success-icon.svg"><?php esc_html_e('Setup completed', 'lightrcommerce'); ?>
            </h1>
        </div>
    </div>
    <div class="flex flex-col">
        <span class="text-lg py-2">
            <?php
            esc_html_e(
                    "Congratulations! Your configuration is completed. You're now all set. Thank you for choosing us, and welcome aboard!",
                    'lightrcommerce'
            );
            ?>
        </span>
    </div>
    <?php
    $catalogPage = (int) get_option('lightrcommerce_bc_catalog_page');
    
    if ($catalogPage) {
    ?>
    <a class="button-primary block" href="<?php echo esc_url(site_url('?p=' . $catalogPage)) ?>" target="_blank">
        <?php
        esc_html_e(
                "View your store",
                'lightrcommerce'
        );
        ?>
    </a>
    <?php } else { ?>
    <p>
        <?php
        $settingsUrl = add_query_arg([
            'page' => 'lightrcommerce_bigcommerce',
            'tab' => 'settings',
                ], admin_url('admin.php')
        );
        ?>
        <span style="color: orange">⚠</span> <?php printf(
            // translators: placeholders are open and close tags of the link
            esc_html__('You must select a page on which to display your products. Please, choose one page in the %1$ssettings page%2$s', "lightrcommerce"),
            '<a href="' . esc_url($settingsUrl) . '" class="underline text-blue-500 hover:no-underline">',
            '</a>'
        ) ?>
    </p>
    <?php } ?>
    <div class="clear-both"></div>
    <?php
    echo \LightrCommerce\Plugin\Helper::getWidgetsListHtml();  // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    ?>
</div>