<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly
?>
<div class="p-4 relative mx-auto block">
    <div>
        <h1><?php esc_html_e('Location store', 'lightrcommerce'); ?></h1>
        <p class="mb-3">
            <?php
            esc_html_e(
                    'Indicate on which page you wan to load the store. This page is used to define the categories other.',
                    'lightrcommerce'
            );
            ?>
        </p>
        <p>
            <?php
            esc_html_e(
                    'Please select a page',
                    'lightrcommerce'
            );
            ?>
        </p>


        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')) ?>">
            <?php wp_nonce_field('lightrcommerce_save_catalog_page') ?>
            <input type="hidden" name="action" value="lightrcommerce_save_catalog_page" />
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">
                        <?php esc_html_e('Catalog Page', 'lightrcommerce'); ?>
                    </th>
                    <td>
                        <?php
                        $areTherePages = wp_count_posts('page')->publish || wp_count_posts('page')->private;

                        if ($areTherePages) {
                            ?>
                            <label for="lightrcommerce_bc_catalog_page">
                                <?php esc_html_e('Select one page:', 'lightrcommerce'); ?>
                            </label>
                            <?php
                            wp_dropdown_pages([
                                'id' => 'lightrcommerce_bc_catalog_page',
                                'name' => 'lightrcommerce_bc_catalog_page',
                                'selected' => (int) get_option('lightrcommerce_bc_catalog_page'),
                                'show_option_none' => 'Select a Page',
                                'required' => true
                            ]);
                        }
                        ?>
                    </td>
                </tr>
            </table>

            <?php submit_button('Use the selected page'); ?>
        </form>

        <?php
        esc_html_e(
                'Create a new page where to load the catalog.',
                'lightrcommerce'
        );
        ?>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')) ?>">
            <?php wp_nonce_field('lightrcommerce_create_catalog_page') ?>
            <input type="hidden" name="action" value="lightrcommerce_create_catalog_page" />
            <div>
                <label>
                    <?php esc_html_e('Name of the new page:', 'lightrcommerce') ?>
                </label>
                <input type="text" name="lightrcommerce_bc_catalog_page_new" class="block w-full" placeholder="<?php esc_attr_e('ex: My Products', 'lightrcommerce') ?>" required />
            </div>

            <div>
                <?php submit_button('Create new page'); ?>
            </div>
        </form>
    </div>
</div>