<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly
?>
<div class="p-4 relative mx-auto block">

    <h1><?php
        esc_html_e(
                'Setup lightRCommerce with BigCommerce',
                'lightrcommerce'
        );
        ?>
    </h1>
    <p class="text-xxs text-gray-400">
        <?php
        esc_html_e(
                'Complete fields to configure the headless connection between your WordPress and your BigCommerce',
                'lightrcommerce'
        );
        ?>
    </p>
    <h3 class="mt-5"><?php esc_html_e('BigCommerce permanent store address', 'lightrcommerce'); ?></h3>
    <p class="mb-3"><?php esc_html_e('Make your first connection between your WordPress and BigCommerce by telling us what your BigCommerce store address is.', 'lightrcommerce'); ?></p>
    <span class="mb-5 block" onclick="document.getElementById('helpMsgContent').style.display = document.getElementById('helpMsgContent').style.display === 'none' ? 'flex' : 'none'">
        <a class="text-xxs text-gray-400 italic cursor-pointer">
            <img class="inline mr-2" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/play_video.svg" alt="play video" title="<?php esc_attr_e('See help video', 'lightrcommerce') ?>">
                <?php
                esc_html_e(
                        "How to find your BigCommerce permanent store address",
                        'lightrcommerce'
                );
                ?>
        </a>
    </span>

    <form id="permanentstore">
        <?php wp_nonce_field('test_bigcommerce_permanent_url') ?>
        <input type="hidden" name="action" value="test_bigcommerce_permanent_url" />
        <div class="flex flex-col">
            <label for="store_permanent_url" class="mb-3 mr-3 font-bold inline-block">
                <?php esc_html_e('BigCommerce permanent store address', 'lightrcommerce'); ?>
            </label>
            <div class="flex justify-between">
                <input
                    id="store_permanent_url"
                    name="store_permanent_url"
                    type="url"
                    required
                    class="rounded-md border mr-3 bg-white w-full px-3.5 py-2 text-black shadow-sm ring-1 ring-inset ring-white/10 focus:ring-2 focus:ring-inset focus:ring-white sm:text-sm sm:leading-6"
                    placeholder="E.g., https://example.mybigcommerce.com"
                    value=""
                    />
                <button class="inline" type="submit">
                    <span class="button-primary default">Connect</span>
                    <span class="button-primary check"><svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><circle class="spinner_S1WN" cx="4" cy="12" r="3"/><circle class="spinner_S1WN spinner_Km9P" cx="12" cy="12" r="3"/><circle class="spinner_S1WN spinner_JApP" cx="20" cy="12" r="3"/></svg></span>
                    <span class="button-primary valid"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">
                            <path id="Icon_ionic-md-checkmark-circle-outline" data-name="Icon ionic-md-checkmark-circle-outline" d="M9.275,11.475l-1.4,1.4,4.5,4.5,10-10-1.4-1.4-8.6,8.55Zm12.1,1.9a7.966,7.966,0,1,1-5.8-7.7l1.55-1.55a9.3,9.3,0,0,0-3.75-.75,10,10,0,1,0,10,10Z" transform="translate(-3.375 -3.375)" fill="#00c40d"/>
                        </svg>

                    </span>
                </button>
            </div>
            <span class="pl-2 mt-1 text-red-500 text-red-600 error-msg"></span>
        </div>

    </form>

    <form id="onboarding" class="deactivated">
        <?php wp_nonce_field('lightrcommerce_setup') ?>
        <input type="hidden" name="action" value="lightrcommerce_setup" />

        <input
            id="lightrcommerce_store_permanent_url"
            name="lightrcommerce_store_permanent_url"
            type="hidden"
            required
            />

        <hr class="my-5" />

        <h3><?php esc_html_e('API Setup', 'lightrcommerce'); ?></h3>
        <p class="mb-3"><?php esc_html_e('Allow LightRCommerce to connect with your store. <strong>Create an API</strong> key and set the corresponding values.', 'lightrcommerce'); ?></p>

        <span class="mb-5 block" onclick="document.getElementById('helpMsgContentAPI').style.display = document.getElementById('helpMsgContentAPI').style.display === 'none' ? 'flex' : 'none'">
            <a class="text-xxs text-gray-400 italic cursor-pointer">
                <img class="inline mr-2" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/play_video.svg" />        
                <?php esc_html_e( "How to generate API in BigCommerce", 'lightrcommerce' ); ?>
            </a>
        </span>

        <div class="flex flex-col mt-5">
            <label
                for="lightrcommerce_client_id"
                class="mb-3 w-1/4 mr-3 font-bold inline-block"
                >
                    <?php esc_html_e('Client ID', 'lightrcommerce'); ?>
            </label>
            <input
                id="lightrcommerce_client_id"
                name="lightrcommerce_client_id"
                type="text"
                required
                class="rounded-md border mr-3 bg-white inline px-3.5 py-2 text-secondary shadow-sm ring-1 ring-inset ring-white/10 focus:ring-2 focus:ring-inset focus:ring-white sm:text-sm sm:leading-6"
                pattern="^[\w0-9]+$"
                placeholder="E.g., 75wv0zqvch5do9bhdmpfd5wsejgq35l"
                value=""
                />
            <span class="text-xxs text-gray-400 italic block pt-2 pb-4">
                <?php
                esc_html_e(
                        'paste the <strong>Client ID</strong> provided for your API account.',
                        'lightrcommerce'
                );
                ?>
            </span>
        </div>

        <div class="flex flex-col">
            <label
                for="lightrcommerce_access_token"
                class="mb-3 w-1/4 mr-3 font-bold inline-block"
                >
                    <?php
                    esc_html_e(
                            'Access Token',
                            'lightrcommerce'
                    );
                    ?><span class="text-red-500">*</span>
            </label>
            <input
                id="lightrcommerce_access_token"
                name="lightrcommerce_access_token"
                type="text"
                required
                invalid
                class="rounded-md border-none mr-3 bg-white px-3.5 py-2 text-secondary shadow-sm ring-1 ring-inset ring-white/10 focus:ring-2 focus:ring-inset focus:ring-white sm:text-sm sm:leading-6 ring-red-500"
                placeholder="E.g., q4vrqweyg9ycngfjae9r0hwtm36ytni"
                />
            <span class="text-xxs text-gray-400 italic block pt-2 pb-4">
                <?php
                esc_html_e(
                        'Enter the <strong>Access Token</strong> provided',
                        'lightrcommerce'
                );
                ?>
            </span>
        </div>

        <span class="pl-2 mt-1 mb-4 text-red-500 text-red-600 error-msg"></span>


        <div class="block mb-4">
            <label class="cursor-pointer">
                <input type="checkbox" name="termsandconditions" required />
                <span>
                    <?php esc_html_e('By continuing you agree to our', 'lightrcommerce'); ?>
                    <a href="https://lightrcommerce.com/terms-conditions" target="_blank" class="underline"><?php esc_html_e('terms and conditions', 'lightrcommerce'); ?></a>.
                </span>
            </label>
        </div>


        <button class="inline button-primary" type="submit"><?php esc_html_e('Save and continue', 'lightrcommerce') ?></button>
    </form>
</div>


<?php /* start dialog permanent adress */ ?>
<div class="dialog" style="display:none;" id="helpMsgContent">
    <div class="fixed top-0 left-0 right-0 bottom-0 backdrop-blur-lg bg-black bg-opacity-10 h-screen z-[9999]">
        <div class="flex h-full w-full justify-center items-center">

            <div class="p-5 relative transition-all delay-300 bg-white w-full sm:w-[800px]  h-auto shadow-inner">
                <span class="absolute right-5 top-5 hover:cursor-pointer h-[20px] w-[20px] bg-gray-700 text-white font-bold rounded-full text-center" onclick="document.getElementById('helpMsgContent').style.display = document.getElementById('helpMsgContent').style.display === 'none' ? 'flex' : 'none'">X</span>

                <h3>
                    <?php
                    esc_html_e(
                            'Locate your BigCommerce Permanent Address',
                            'lightrcommerce'
                    );
                    ?>:
                </h3>
                <p class="mb-10">
                    <?php
                    esc_html_e(
                            'Follow these simple steps to find your permanent graphql address.',
                            'lightrcommerce'
                    );
                    ?>:
                </p>
                <div class="text-base">
                    <ul>
                        <li>
                            <span class="font-bold">1. </span>
                            <?php
                            esc_html_e(
                                    'Enter your BigCommerce store.',
                                    'lightrcommerce'
                            );
                            ?>
                        </li>
                        <li>
                            <span class="font-bold">2. </span>
                            <?php
                            esc_html_e(
                                    'Choose <strong>Settings</strong>',
                                    'lightrcommerce'
                            );
                            ?> »
                            <strong><?php
                                esc_html_e(
                                        'Account Settings',
                                        'lightrcommerce'
                                );
                                ?></strong> »
                            <strong><?php
                                esc_html_e(
                                        'Store Details',
                                        'lightrcommerce'
                                );
                                ?></strong> »
                            <strong><?php
                                esc_html_e(
                                        'Details',
                                        'lightrcommerce'
                                );
                                ?></strong>
                        </li>
                    </ul>
                    <div style="padding:75% 0 0 0;position:relative"><iframe src="https://player.vimeo.com/video/910358135?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" style="position:absolute;top:0;left:0;width:100%;height:100%" title="locate_permanent_store_addres"></iframe></div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php /* end dialog permanent adress */ ?>

<?php /* start dialog help API locate */ ?>
<div class="dialog" style="display:none" id="helpMsgContentAPI">
    <div class="fixed top-0 left-0 right-0 bottom-0 backdrop-blur-lg bg-black bg-opacity-10 h-screen z-[9999]">
        <div class="flex h-full w-full justify-center items-center">

            <div class="p-5 relative transition-all delay-300 bg-white w-full sm:w-[800px]  h-auto shadow-inner">
                <span class="absolute right-5 top-5 hover:cursor-pointer h-[20px] w-[20px] bg-gray-700 text-white font-bold rounded-full text-center" onclick="document.getElementById('helpMsgContentAPI').style.display = document.getElementById('helpMsgContentAPI').style.display === 'none' ? 'flex' : 'none'">X</span>

                <h3>
                    <?php
                    esc_html_e(
                            'Create new API access in BigCommerce',
                            'lightrcommerce'
                    );
                    ?>:
                </h3>
                <p class="mb-10">
                    <?php
                    esc_html_e(
                            'Follow these steps to create an API key in BigCommerce.',
                            'lightrcommerce'
                    );
                    ?>:
                </p>
                <div class="text-base">
                    <ul>
                        <li>
                            <span class="font-bold">1. </span>
                            <?php
                            esc_html_e(
                                    'Enter your BigCommerce store.',
                                    'lightrcommerce'
                            );
                            ?>
                        </li>
                        <li>
                            <span class="font-bold">2. </span>
                            <?php
                            esc_html_e(
                                    'Choose <strong>Settings</strong>',
                                    'lightrcommerce'
                            );
                            ?> »
                            <strong><?php
                                esc_html_e(
                                        'Go to section API',
                                        'lightrcommerce'
                                );
                                ?></strong> »
                            <strong><?php
                                esc_html_e(
                                        'Create new API',
                                        'lightrcommerce'
                                );
                                ?></strong> »
                            <strong><?php
                                esc_html_e(
                                        'Store level API',
                                        'lightrcommerce'
                                );
                                ?></strong>
                        </li>
                    </ul>
                    <p>
                        <?php
                        esc_html_e(
                                'Important to give <u><strong>ALL</strong></u> permissions to make sure the headless store is full compatible.',
                                'lightrcommerce'
                        );
                        ?></p>
                    <div style="padding:75% 0 0 0;position:relative"><iframe src="https://player.vimeo.com/video/910355607?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" style="position:absolute;top:0;left:0;width:100%;height:100%" title="BigCommerce setup API"></iframe></div>
                </div>
            </div>
        </div>
    </div>
</div>