<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly
?>
<div class="p-3 mx-auto max-w-6xl">
    <div>
        <span>
            <img class="w-60 inline" src="<?php echo esc_html(LIGHTRCOMMERCE_ASSETS_URL) ?>/lightr_logo.svg" alt="LightR Commerce logo" />
            <span class="text-base text-white inline -bottom-1 right-0 font-semibold bg-lightrbase px-4 ring ring-white"><?php
                esc_html_e(
                        'NODE',
                        'lightrcommerce'
                );
                ?></span>
        </span>
        <h1><?php
            esc_html_e(
                    'Headless Commerce for WordPress.',
                    'lightrcommerce'
            );
            ?> </h1>
        <p class="mt-8 text-xl">
            <?php
            esc_html_e(
                    'You are just a couple of clicks away from adding modern eCommerce onto your WordPress',
                    'lightrcommerce'
            );
            ?>:
        </p> 
        <p class="text-lg"><?php
            esc_html_e(
                    'Start the wizard to setup the headless connection between your eCommerce platorm and your WordPress instalation.',
                    'lightrcommerce'
            );
            ?> </p>


    </div>
    <p class="mt-8 text-base">
        <?php
        esc_html_e(
                'Select your preferred eCommerce platform to load headless to your WordPress',
                'lightrcommerce'
        );
        ?>:
    </p>
    <div id="bigcommerce">
        <span class="flex justify-items-center gap-10 border p-5 rounded">
            <span class="w-[70%]">
                <img src="<?php echo esc_html(LIGHTRCOMMERCE_ASSETS_URL) ?>/bigcommerce.svg" width="200" alt="BigCommerce logo">
                <p class="text-gray-600 mt-3">
                    <?php
                    esc_html_e(
                            "Setup your WordPress with the worlds' leading Open SaaS eCommerce platform.",
                            'lightrcommerce'
                    );
                    ?>      </p>
            </span>
            <span class="w-[300px]">
                <span >
                    <p class="text-base font-bold"><?php
                        esc_html_e(
                                'No BigCommerce account yet?',
                                'lightrcommerce'
                        );
                        ?></p>
                    <a class="p-3 bg-purple border border-purple rounded hover:text-black hover:bg-white block text-white" href="https://www.bigcommerce.es/comienza-tu-prueba/?utm_medium=partner&utm_source=young-dogs&utm_campaign=ap_emea_es_all_acq_core_core_trial_2023_q2_youngdogs-WordPress-plugin_intl" target="_blank">
                        <?php esc_html_e('Sign up new BigCommerce account', 'lightrcommerce'); ?>
                    </a>
                    <p class="font-italic">
                        <?php
                        esc_html_e(
                                'Sign up and try for free',
                                'lightrcommerce'
                        );
                        ?>
                    </p>
                </span>
                <span class="mt-10 block"><p><?php esc_html_e('I have BigCommerce setup and want to continue', 'lightrcommerce'); ?></p>
                    <a class="bg-lightrbase border border-lightrbase hover:bg-white rounded p-3 block" href="?page=lightrcommerce_wizard&tab=step1"><?php
                        esc_html_e(
                                'Connect BigCommerce now',
                                'lightrcommerce'
                        );
                        ?></a>
                </span>
            </span>
        </span>
    </div>
</div>
