<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly
?>
<?php
$isSetupCompleted = \LightrCommerce\Plugin\Helper::isSetupCompleted();

if ($isSetupCompleted) {
    $currentTab = 3;
} else {
    $currentTab = str_replace('step', '', filter_input(INPUT_GET, 'tab', FILTER_SANITIZE_FULL_SPECIAL_CHARS) ?? 0);
}

$tabs = [
    0 => [
        'label' => '',
        'icon' => '<svg xmlns="http://www.w3.org/2000/svg" class="inline-block" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 60 60" enable-background="new 0 0 60 60" xml:space="preserve"><g><defs><rect id="SVGID_1_" width="60" height="60"></rect></defs><clipPath id="SVGID_2_"><use xlink:href="#SVGID_1_" overflow="visible"></use></clipPath><g id="Artboard_13" clip-path="url(#SVGID_2_)"><g id="Group_2189" transform="translate(-6.992 -2.841)"><g id="Group_4" transform="translate(28.753 35.221)"><path id="Path_9" fill="#000000" stroke="#000000" stroke-width="0.5" d="M8.249,15.624L0,7.811L8.249,0l8.249,7.812      L8.249,15.624z M2.549,7.811l5.7,5.4l5.7-5.4l-5.7-5.399L2.549,7.811z"></path></g><g id="Group_5" transform="translate(17.992 14.841)"><path id="Path_10" fill="#000000" stroke="#000000" stroke-width="0.5" d="M31.021,24.629L19.01,13.252L6.998,24.627l-7-6.627      l19.01-18l19.01,18L31.021,24.629z M2.548,18.002l4.451,4.215l12.012-11.375l12.012,11.375l4.451-4.215L19.011,2.408 L2.548,18.002z"></path></g></g></g></g></svg>',
        'url' => '?page=lightrcommerce_wizard'
    ],
    1 => [
        'label' => '1',
        'url' => '?page=lightrcommerce_wizard&tab=step1'
    ],
    2 => [
        'label' => '2',
        'url' => '?page=lightrcommerce_wizard&tab=step2'
    ],
    3 => [
        'label' => '3',
        'url' => '?page=lightrcommerce_wizard&tab=step3'
    ]
];
?>
<div id="onboardingForm" class="mt-4 shadow-md mr-[20px]">
    <div class="flex grow flex-row bg-white">
        <!-- Stepper -->
        <div class="p-2 flex-col bg-lightrbase">
            <div class="flex place-content-center pt-8">
            </div>
            <?php if (!$isSetupCompleted) { ?>
                <div class="flex-col relative z-1 before:content-[''] before:block before:w-1 before:-ml-0.5 before:h-full before:bg-white before:absolute before:left-1/2 before:right-0 before:top-0 before:bottom-0 before:z-10">
                    <span class="flex flex-col gap-6 text-center place-items-center z-20 relative">
                        <?php
                        foreach ($tabs as $tabIndex => $tabData) {
                            $current = $tabIndex == $currentTab;
                            $completed = $currentTab >= $tabIndex;
                            
                            $linkClasses = [
                                'border-2 cursor-default w-[48px] h-[48px] flex place-content-center place-items-center rounded-full p-2 no-underline',
                            ];

                            if ($current) {
                                $linkClasses[] = 'border-gray-500';
                            } else {
                                $linkClasses[] = 'border-white';
                            }

                            if ($completed) {
                                $linkClasses[] = 'bg-white text-lightrbase';
                            } else {
                                $linkClasses[] = 'bg-lightrbase text-white';
                            }
                            ?>
                            <span class="<?php echo esc_attr(implode(' ', $linkClasses)) ?>"> 
                                <?php echo empty($tabData['icon']) ? esc_html($tabData['label']) : LightrCommerce\Plugin\Helper::printUnescapedInternalString($tabData['icon']) // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                            </span>
                        <?php } ?>
                    </span>
                </div>
            <?php } ?>
        </div>
        <div class="min-h-[450px] p-4">
            <?php
            $tabContent = sprintf('%s/wizard/step%d.php', __DIR__, $currentTab);
            require $tabContent;
            ?>
        </div>
    </div>
</div>