<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly

$catalogPageId = get_option('lightrcommerce_bc_catalog_page');
?>
<div>
    <h3 class="py-5">BigCommerce Headless Settings</h3>
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')) ?>">
        <?php wp_nonce_field('lightrcommerce_save_settings') ?>
        <input type="hidden" name="action" value="lightrcommerce_save_settings" />

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-5">
            <div>  
                <strong><?php esc_html_e('Enable frontend output of this module', 'lightrcommerce') ?></strong>
            </div>  
            <div>  
                <input type="checkbox" name="lightrcommerce_bc_frontend_enabled" value="1" <?php echo get_option('lightrcommerce_bc_frontend_enabled') ? 'checked' : null ?> />
            </div>    
            <div>
                <strong><?php esc_html_e('Default catalog page', 'lightrcommerce') ?></strong>
                <p><?php esc_html_e('The default store URL is used by the plugin to inject the headless data and start the catalog navigation as defined in your eCommerce platform.', 'lightrcommerce') ?></p>
            </div>

            <div>
                <?php
                wp_dropdown_pages([
                    'name' => 'lightrcommerce_bc_catalog_page',
                    'selected' => (int) $catalogPageId,
                    'show_option_none' => 'Select a page',
                    'class' => 'w-full block mb-3'
                ])
                ?>
                <a class="button-secondary" href="<?php echo esc_url(site_url("?p=$catalogPageId")) ?>" target="_blank">
                    <svg class="inline mr-2" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 31.5 21.234">
                        <path id="Icon_ionic-md-eye" data-name="Icon ionic-md-eye" d="M18,7.383A16.936,16.936,0,0,0,2.25,18a16.991,16.991,0,0,0,31.5,0A16.936,16.936,0,0,0,18,7.383Zm0,17.7A7.081,7.081,0,1,1,25.158,18,7.139,7.139,0,0,1,18,25.08Zm0-11.327A4.247,4.247,0,1,0,22.3,18,4.285,4.285,0,0,0,18,13.753Z" transform="translate(-2.25 -7.383)"/>
                    </svg>
                    <?php esc_html_e('View page', 'lightrcommerce') ?>
                </a>
            </div>
        </div>

        <?php
        submit_button()
        ?>
    </form>

    <div class="border-t border-black py-5">
        <h3><?php esc_html_e('Technical information', 'lightrcommerce') ?></h3>
        <p><?php esc_html_e('For debugging information only. Share this data only with the lightrCommerce Support', 'lightrcommerce') ?></p>

        <span class="lg:grid grid-cols-2">
            <label><?php esc_html_e('Permanent store URL', 'lightrcommerce') ?></label>
            <input class="w-full" type="text" value="<?php echo esc_attr(get_option('lightrcommerce_bc_permanent_url')) ?>" readonly />
        </span>

        <?php
        $storeUrls = LightrCommerce\BigCommerce\Helper::parsePermanentStoreUrl(get_option('lightrcommerce_bc_permanent_url'));
        ?>
        <span class="lg:grid grid-cols-2">
            <label><?php esc_html_e('Middleware ID', 'lightrcommerce') ?></label>
            <input class="w-full" type="text" value="<?php echo esc_attr(get_option('lightrcommerce_bc_endpoint_id')) ?>" readonly />
        </span>

        <span class="lg:grid grid-cols-2">
            <label><?php esc_html_e('Middleware name', 'lightrcommerce') ?></label>
            <input class="w-full" type="text" value="<?php echo esc_attr(get_option('lightrcommerce_bc_endpoint_name')) ?>" readonly />
        </span>

        <span class="lg:grid grid-cols-2">
            <label><?php esc_html_e('Channel ID', 'lightrcommerce') ?></label>
            <input class="w-full" type="text" value="<?php echo esc_attr($storeUrls->channelId) ?>" readonly />
        </span>

        <span class="lg:grid grid-cols-2">
            <label><?php esc_html_e('Store hash', 'lightrcommerce') ?></label>
            <input class="w-full" type="text" value="<?php echo esc_attr($storeUrls->storeHash) ?>" readonly />
        </span>

        <span class="lg:grid grid-cols-2">
            <label><?php esc_html_e('API URL', 'lightrcommerce') ?></label>
            <input class="w-full" type="text" value="<?php echo esc_attr($storeUrls->apiUrl) ?>" readonly />
        </span>

        <span class="lg:grid grid-cols-2">
            <label><?php esc_html_e('GraphQL URL', 'lightrcommerce') ?></label>
            <input class="w-full" type="text" value="<?php echo esc_attr($storeUrls->graphqlUrl) ?>" readonly />
        </span>
    </div>

    <div class="border-t border-b border-black py-5">
        <h3><?php esc_html_e('Widgets configuration', 'lightrcommerce') ?></h3>
        <p><?php esc_html_e('If you have errors working with our widgets, you can try clearing the widgets configuration cache.', 'lightrcommerce') ?></p>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')) ?>">
            <?php wp_nonce_field('lightrcommerce_clear_widgets_cache') ?>
            <input type="hidden" name="action" value="lightrcommerce_clear_widgets_cache" />
            <?php
            submit_button(esc_html__('Clear widgets configuration cache', 'lightrcommerce'))
            ?>
        </form>
    </div>
</div>

