<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly
?>
<h3 class="py-5"><?php esc_html_e('BigCommerce Headless Status', 'lightrcommerce') ?></h3>
<ul class="lg:grid lg:grid-cols-2 gap-5 border-b border-black mb-5">
    <li>
        <div class="rounded-lg p-5 bg-white">
            <div class="flex flex-row h-10">
                <div class="flex flex-row p-2 items-center justify-between  w-full">
                    <p class="text-[#070A3A] font-[400] text-[20px]">BigCommerce API</p>
                    <?php if ((new \LightrCommerce\Plugin\Api\BigCommerceApiService)->isMiddlewareActive()) { ?>
                        <span class="self-end mt-1 bg-[#6CCD15] inline-block h-6 w-6 rounded-full align-middle"></span>
                    <?php } else { ?>
                        <span class="self-end mt-1 bg-red-500 inline-block h-6 w-6 rounded-full align-middle"></span>
                    <?php } ?>
                </div>
            </div>
        </div>
        <a href="https://lightrcommerce.com/support" target="_blank"><p class="flex justify-end text-[#070A3A]">help<img class="pl-3 pt-1" src="<?php echo esc_html(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/arrowTriangle.svg"></p></a>
    </li>
    <li class="basis-2/5">
        <div class="rounded-lg p-5 bg-white">
            <div class="flex flex-row h-10">
                <div class="flex flex-row p-2 items-center justify-between  w-full">
                    <p class="text-[#070A3A] font-[400] text-[20px]">LightR Headless middleware</p>
                    <span class="self-end mt-1 bg-[#6CCD15] inline-block h-6 w-6 rounded-full align-middle"></span>
                </div>
            </div>
        </div>
        <a href="https://lightrcommerce.com/support" target="_blank"><p class="flex justify-end text-[#070A3A]">help<img class="pl-3 pt-1" src="<?php echo esc_html(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/arrowTriangle.svg"></p></a>
    </li>
</ul>

<div>
    <?php
    echo \LightrCommerce\Plugin\Helper::getWidgetsListHtml(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    ?>
    <a href="https://lightrcommerce.com/contact-sales" target="_blank"><p class="flex justify-end text-[#070A3A]">help<img class="pl-3 pt-1" src="<?php echo esc_html(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/arrowTriangle.svg"></p></a>
</div>
