<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly
?>
<div class="lg:min-h-[500px] border-b border-black">
    <h3 class="py-5"><?php esc_html_e('Advanced settings', 'lightrcommerce') ?></h3>
    <div>
        <strong><?php esc_html_e('Delete account', 'lightrcommerce') ?></strong>
        <p><?php esc_html_e('Warning this function will delete your headless connection between your eCommerce platform and your WordPress.', 'lightrcommerce') ?></p>
    </div>    
    <div>
        <button id="btn-show-popup" class="p-2 bg-[#D43727] rounded text-white text-[14px]">
            <?php esc_html_e('Delete my data', 'lightrcommerce') ?>
            <img class="pl-3 inline" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/arrowTriangleWhite.svg">
        </button>
    </div>
</div>
<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')) ?>" id="lightrcommerce-uninstall">
    <?php wp_nonce_field('lightrcommerce_uninstall') ?>
    <input type="hidden" name="action" value="lightrcommerce_uninstall" />
</form>
<div id="darkBg" hidden class="popup-closer z-[10000] fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"></div>
<div id="popup" hidden class="z-[10001] fixed left-0 right-0 m-auto w-[40rem] bg-white border border-black top-[25vh] p-5">
    <h3 class="text-red-500"><?php esc_html_e('Final notice', 'lightrcommerce') ?></h3>
    <span class="font-bold mt-5"><?php esc_html_e('Delete LightR Commerce data', 'lightrcommerce') ?></span>
    <p><?php esc_html_e('You are about to delete the connection between your WordPress installation and your eCommerce platform.', 'lightrcommerce') ?></p>
    <div class="flex flex-row justify-between">
        <button type="submit" form="lightrcommerce-uninstall">
            <p class="mt-8 hover:underline">
                <?php esc_html_e('Yes, delete my headless', 'lightrcommerce') ?>
            </p>
        </button>
        <button id="closeButton" class="popup-closer">
            <span class="button-primary"><?php esc_html_e('Get me out of here', 'lightrcommerce') ?></span>
        </button>
    </div>
</div>