<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly
?>
<div class="flex grow flex-row bg-white">
    <div class="p-2 flex-col bg-lightrbase pt-8">
        <span class="hover:text-white border-2 border-white bg-lightrbase cursor-default w-[48px] h-[48px]  flex place-content-center place-items-center rounded-full p-2 no-underline text-white "> 
            <svg xmlns="http://www.w3.org/2000/svg" class="inline-block" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 60 60" enable-background="new 0 0 60 60" xml:space="preserve"><g><defs><rect id="SVGID_1_" width="60" height="60"></rect></defs><clipPath id="SVGID_2_"><use xlink:href="#SVGID_1_" overflow="visible"></use></clipPath><g id="Artboard_13" clip-path="url(#SVGID_2_)"><g id="Group_2189" transform="translate(-6.992 -2.841)"><g id="Group_4" transform="translate(28.753 35.221)"><path id="Path_9" fill="#FFFFFF" stroke="#FFFFFF" stroke-width="0.5" d="M8.249,15.624L0,7.811L8.249,0l8.249,7.812      L8.249,15.624z M2.549,7.811l5.7,5.4l5.7-5.4l-5.7-5.399L2.549,7.811z"></path></g><g id="Group_5" transform="translate(17.992 14.841)"><path id="Path_10" fill="#FFFFFF" stroke="#FFFFFF" stroke-width="0.5" d="M31.021,24.629L19.01,13.252L6.998,24.627l-7-6.627      l19.01-18l19.01,18L31.021,24.629z M2.548,18.002l4.451,4.215l12.012-11.375l12.012,11.375l4.451-4.215L19.011,2.408 L2.548,18.002z"></path></g></g></g></g></svg>
        </span>
    </div>
    <div class="p-8">
        <span>
            <img class="w-60 inline" src="<?php echoesc_attr_e(LIGHTRCOMMERCE_ASSETS_URL) ?>/lightr_logo.svg">
                <span class="text-base text-white inline -bottom-1 right-0 font-semibold bg-lightrbase px-4 ring ring-white">NODE</span>
        </span>
        <h1>
            <?php
            esc_html_e(
                    'Thank you for using LightR Commerce',
                    'lightrcommerce'
            );
            ?>    
        </h1>
        <p class="mb-4">
            <?php
            esc_html_e(
                    'We hope to see you again soon!',
                    'lightrcommerce'
            );
            ?>    
        </p>
        <p>
            <?php
            esc_html_e(
                    'If you want to stay informed about future releases, join our newsletter.',
                    'lightrcommerce'
            );
            ?>
            <br/>
            <br/>
        </p>
        <a class="button-primary" href="https://lightrcommerce.com/keep-informed" target="_blank">
            <?php
            esc_html_e(
                    "Sign-up newsletter",
                    'lightrcommerce'
            );
            ?>    
        </a>
    </div>
</div>
