<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly

$isElementorActive = \LightrCommerce\Plugin\Helper::isElementorActive();
$affiliateTag = '217828';

if ($isElementorActive) {
    // Elementor is active, do something if needed
} else {
    ?>
    <div class="text-center">
        <hr class="my-3">
        <p>
            <?php
            esc_html_e(
                    'LightR Commerce works best with <strong>Elementor</strong>. We strongly recommend you to install.',
                    'lightrcommerce'
            );
            ?>
        </p>
        <div class="inline-block mx-auto bg-neutral-100 relative ring-1 ring-neutral-300 rounded-md shadow-inner mt-4 relative p-3">
            <div class="pb-4 text-center">
                <h3><?php esc_html_e('Get', 'lightrcommerce'); ?><a href="https://be.elementor.com/visit/?bta=217829&nci=5349&utm_campaign=lightr-install" target="_blank"><img class="inline ml-1" width="160" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/elementor-logo-full.svg" alt="Get Elementor"></a></h3>
                <p class="text-base"><?php esc_html_e('Power your vision with Elementor to build, manage and host stunning websites!', 'lightrcommerce'); ?></p>
                <p>
                    <?php
                    esc_html_e(
                            'Elementor got you covered from A-to-Z with the #1 website platform for WordPress.',
                            'lightrcommerce'
                    );
                    ?>
                    <br />
                    <br />
                </p>
                <a class="button-primary" href="https://be.elementor.com/visit/?bta=217829&nci=5349&utm_campaign=lightr-install" target="_blank"><?php
                    esc_html_e(
                            'Get elementor.',
                            'lightrcommerce'
                    );
                    ?></a>
            </div>
        </div>
        <hr class="my-3">
    </div>
    <?php
}
?>

<?php
$widgets = \LightrCommerce\Plugin\Helper::getWidgetsList();

if ($widgets) {
    ?>
    <div class="wp-core-ui">
        <h3 class="my-3"><?php esc_html_e('Available LightRCommerce widgets', 'lightrcommerce') ?></h3>
        <ul class="widgets-list">
            <?php foreach ($widgets as $widget) { ?>
                <li class="border-2 p-2 bg-white flex items-center">
                    <img src="<?php echo esc_attr($widget->icon) ?>" class="p-2" style="width:48px; opacity:0.5; vertical-align: middle; display: inline-block; pointer-events: none" />
                    <span style="flex: 1"><?php echo esc_html($widget->name) ?></span>
                    <span>
                        <?php if ($widget->premium) { ?>
                            <a href="https://lightrcommerce.com/getpro" class="focus:ring-0" target="_blank">
                                <span class="mr-3 inline-block p-2 text-[#070A3A] bg-amber-400 rounded text-sm">GET PRO<img class="pl-14 inline" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/arrowTriangle.svg"></span>
                            </a>
                        <?php } ?>
                        <?php if ($widget->wordpress) { ?>
                            <img src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/wordpress.svg" style="width: 30px; display: inline-block; pointer-events: none; margin-bottom:3px" alt="WordPress icon" title="<?php esc_attr_e('Widget enabled for WordPress pages', 'lightrcommerce') ?>" />
                        <?php } ?>
                        <?php if ($widget->elementor) { ?>
                            <span class="e-logo-wrapper" title="<?php esc_attr_e('Widget enabled for Elementor', 'lightrcommerce') ?>">
                                <i class="eicon-elementor" style="width: 12px; height:12px; display: inline-block; pointer-events: none" aria-hidden="true"></i>
                            </span>
                        <?php } ?>
                    </span>
                </li>
            <?php } ?>
        </ul>

        <?php if (get_theme_support('widgets')) { ?>
            <a class="button-primary float-right" href="<?php echo esc_url(admin_url('widgets.php')) ?>">
                <?php esc_html_e("Insert Widget now", 'lightrcommerce'); ?>
            </a>
        <?php } else { ?>
            <span style="color: orange">⚠</span>
            <?php
            printf(
                // translators: 1: current theme name, 2: link to admin themes page
                wp_kses('Your current theme <strong>%1$s</strong> does not support <strong>Widgets</strong>. For better compatibility, we recommend you to <a href="%2$s" class="underline text-blue-500 hover:no-underline">switch your theme</a> to a one with support for Widgets. One common WordPress theme with support for Widgets is <strong>Twenty Twenty-One</strong>.', "lightrcommerce"),
                esc_html(wp_get_theme()->Name),
                esc_url(admin_url('themes.php'))
            )
            ?>
        <?php } ?>
    </div>
    <?php
}