<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly
?>
<div>
    <span class="block py-3 border-b border-lightrbase">
        <?php esc_html_e('LightR recommendations for you', 'lightrcommerce') ?>
    </span>    
    <div class="flex flex-col">
        <div class="rounded-md bg-[#fcc00e] mt-16">
            <div class="relative p-4 pb-10">
                <img class="w-[20%] absolute -top-10 right-[40%] rounded-md bg-lightrbase" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/lightRAmber.svg">
                <h2 class="text-[#422E0C]">Tailormade</h2>
                <p class="text-[#422E0C]">Elevate your shopping with an optional checkout experience, where special styling and shopping experience meets unique products requirements.</p>
                <p class="text-[#422E0C]">Tailormade shopping experiences up to API data migrations for your eCommerce platform.</p>
                <a class="focus:ring-0" href="https://lightrcommerce.com/contact-sales" target="_blank">
                    <h3 class="flex justify-between shadow-lg p-3 bg-white rounded-lg">
                        <?php esc_html_e('Contact Pro team', 'lightrcommerce') ?>
                        <img class="pt-2" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/arrowTriangle.svg">
                    </h3>
                </a>
            </div>
            <img class="w-full rounded-md" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/imageHands.png">
        </div>
        <div class="relative rounded-md bg-blue-950 mt-16">
            <div class="p-3">
                <img class="w-[20%] absolute -top-10 right-[40%] rounded-md p-3 bg-blue-950" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/lightRWhite.svg">
                <h2 class="text-white">Discover our B2B</h2>
                <p class="text-white">LightR Commerce redefines commerce with optional features such as tailored B2B pricing models, quick order forms, CSV order upload, and more.</p>
                <p class="text-white">Elevate your business transactions with a unique blend of customization and efficiency, exclusively designed for businesses selling to businesses.</p>
                <a class="focus:ring-0" href="https://lightrcommerce.com/contact-sales" target="_blank">
                    <h3 class="flex justify-between p-2 text-white rounded-lg">
                        Contact B2B team
                        <img class="pt-2" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/arrowTriangleWhite.svg">
                    </h3>
                </a>
            </div>
        </div>
        <div class="relative rounded-md bg-[#fc850e] mt-16">
            <div class="p-3">
                <img class="w-[20%] absolute -top-10 right-[40%] rounded-md" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/lightROrange.svg">
                <h2 class="text-[#422E0C]">
                    <?php esc_html_e('Support', 'lightrcommerce') ?>
                </h2>
                <p>Elevate your shopping with an optional checkout experience, where special styling meets unique products. Unleash your individuality as you explore exclusive offerings. Tailormade, where customization is not just an option; it's your signature style.</p>
                <a class="focus:ring-0" href="https://lightrcommerce.com/contact-sales" target="_blank">
                    <h3 class="flex justify-between shadow-lg p-3 bg-white rounded-lg">
                        Get premium support<img class="pt-2" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/arrowTriangle.svg">
                    </h3>
                </a>
                <a class="focus:ring-0" href="https://lightrcommerce.com/support" target="_blank">
                    <h3 class="flex p-2 text-[#070A3A] text-xl">
                        visit support pages
                        <img class="pl-5 pt-2" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/icons/arrowTriangle.svg">
                    </h3>
                </a>
            </div>
            <img class="w-full rounded-md" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/imageWorker.png">
        </div>
    </div>
</div>  