<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly

/* @var $ex Exception */
?>
<h1>
    <?php esc_html_e('Oops! An error occured!', 'lightrcommerce'); ?>
</h1>
<?php if (WP_DEBUG && WP_DEBUG_DISPLAY) { ?>
    <p>
        <?php esc_html_e('Below you can see details of the error (because WordPress debug mode is ON).', 'lightrcommerce'); ?>
    </p>
    <details>
        <summary><?php echo esc_html($ex->getMessage()) ?></summary>
        <pre class="error" style="border: 1px solid red; border-left-width: 10px; padding: 0.625em; white-space: break-spaces"><?php echo esc_html($ex) ?></pre>
    </details>
    <?php
}