<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly

$services = ['BigCommerce'];
?>
<?php require LIGHTRCOMMERCE_TEMPLATE_PATH . '/partials/lightr_header.php' ?>
<div class="lg:flex gap-10">
    <main class="w-full lg:w-4/5">
        <?php
        /**
         * Admin Settings page template
         * */
        $assets_folder = plugin_dir_url(__DIR__) . 'templates/assets/';

        $tabs = [
            [
                'code' => 'dashboard',
                'label' => __('Dashboard', 'lightrcommerce'),
            ],
        ];

        $tabs = json_decode(wp_json_encode($tabs));
        
        $currentTab = filter_input(INPUT_GET, 'tab', FILTER_SANITIZE_FULL_SPECIAL_CHARS) ?? $tabs[0]->code;
        ?>

        <h2 class="nav-tab-wrapper">
            <?php foreach ($tabs as $tab) { ?>
                <a href="#" class="nav-tab<?php echo $currentTab == $tab->code ? ' nav-tab-active' : '' ?>">
                    <?php echo esc_html($tab->label) ?>
                </a>
            <?php } ?>
        </h2>
        <div class="border-b border-black py-3">
            <h3 class="mb-5"><?php esc_html_e('Headless Activation state', 'lightrcommerce') ?></h3>
            <ul class="lg:grid lg:grid-cols-2 girmt-5 gap-5">
                <?php
                foreach ($services as $service) {
                    $className = sprintf('LightrCommerce\\Plugin\\Api\\%sApiService', $service);
                    // @var $class LightrCommerce\Plugin\Api\ApiServiceInterface
                    $class = new $className;
                    $dotColor = $class->isMiddlewareActive() ? 'bg-[#6CCD15]' : 'bg-[#CD1552]';
                    $bgColor = $class->isMiddlewareActive() ? 'bg-white' : 'bg-[#F4F4F5]';

                    $url = add_query_arg(['page' => 'lightrcommerce_' . $class->getCode(), 'tab' => 'settings'], get_admin_url() . 'admin.php');
                    ?>
                    <li class="<?php echo esc_attr($bgColor) ?> rounded-lg p-5">
                        <a href="<?php echo esc_url($url) ?>" class="block border-b border-black mb-5">
                            <img class="pb-5 h-16" src="<?php echo esc_attr(LIGHTRCOMMERCE_ASSETS_URL) ?>/<?php echo esc_attr($class->getCode()) ?>.svg">
                        </a>

                        <div class="flex flex-row justify-between">
                            <div class="flex flex-row p-2 items-center space-x-2 h-10">
                                <span class="text-indigo-800">
                                    <?php esc_html_e('Headless state', 'lightrcommerce') ?>
                                </span>
                                <span class="<?php echo esc_attr($dotColor) ?> inline-block h-3 w-3 rounded-full align-middle"></span>
                            </div>
                            <div class="flex flex-row p-2 items-center space-x-2 h-10">
                                <span class="text-indigo-800">
                                    <?php esc_html_e('Enabled', 'lightrcommerce') ?>
                                    <a href="<?php echo esc_url($url) ?>">
                                        <?php if ($class->isFrontendEnabled()) { ?>
                                            <span type="button" class="bg-indigo-950 relative inline-flex h-4 w-11 flex-shrink-0 rounded border-2 border-transparent transition-colors duration-200 ease-in-out" aria-checked="true">
                                                <span aria-hidden="true" class="translate-x-7 pointer-events-none inline-block h-3 w-3 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                                            </span>
                                        <?php } else { ?>
                                            <span type="button" class="bg-gray-200 relative inline-flex h-4 w-11 flex-shrink-0 rounded border-2 border-transparent transition-colors duration-200 ease-in-out" aria-checked="false">
                                                <span aria-hidden="true" class="translate-x-0 pointer-events-none inline-block h-3 w-3 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                                            </span>
                                        <?php } ?>
                                    </a>
                                </span>
                            </div>
                        </div>
                    </li>
                <?php } ?>
            </ul>
        </div>
        <?php require LIGHTRCOMMERCE_TEMPLATE_PATH . '/partials/information_footer.php' ?>
    </main>

    <aside class="w-full lg:w-1/5">
        <?php require LIGHTRCOMMERCE_TEMPLATE_PATH . '/partials/support.php' ?>
    </aside>
</div>