<?php
if (!defined('ABSPATH')) exit; // exit if accessed directly
?>
<div class="lightr-wrapper">
    <?php include LIGHTRCOMMERCE_TEMPLATE_PATH . '/partials/lightr_header.php' ?>
    <?php
    //if (!\LightrCommerce\Plugin\Helper::isSetupCompleted()) {
    //    require __DIR__ . '/wizard.php';
    //    return;
    //}
    ?>
    <div class="lg:flex gap-10">
        <main class="w-full lg:w-4/5">
            <?php
            /**
             * Admin Settings page template
             * */
            $assets_folder = plugin_dir_url(__DIR__) . 'templates/assets/';

            $tabs = [
                [
                    'code' => 'general',
                    'label' => 'Status',
                ],
                [
                    'code' => 'settings',
                    'label' => 'Settings',
                ],
                [
                    'code' => 'advanced',
                    'label' => 'Advanced settings',
                ],
            ];

            // convert array to object recursively
            $tabs = json_decode(wp_json_encode($tabs));

            $currentTab = filter_input(INPUT_GET, 'tab', FILTER_SANITIZE_FULL_SPECIAL_CHARS) ?? $tabs[0]->code;
            ?>

            <h2 class="nav-tab-wrapper">
                <?php foreach ($tabs as $tab) { ?>
                    <a href="?page=lightrcommerce_bigcommerce&tab=<?php echo esc_attr($tab->code) ?>" class="nav-tab<?php echo $currentTab == $tab->code ? ' nav-tab-active' : '' ?>">
                        <?php echo esc_html($tab->label) ?>
                    </a>
                <?php } ?>
            </h2>

            <?php
            // prevent load of unwanted files
            $cleanCurrentTab = pathinfo($currentTab, PATHINFO_FILENAME);

            $pageToLoad = sprintf('%s/settings/%s.php', __DIR__, $cleanCurrentTab);

            if (file_exists($pageToLoad)) {
                require $pageToLoad;
            }
            ?>
            <?php require LIGHTRCOMMERCE_TEMPLATE_PATH . '/partials/information_footer.php' ?>
        </main>

        <aside class="w-full lg:w-1/5">
            <?php require __DIR__ . '/partials/support.php' ?>
        </aside>
    </div>
</div>