jQuery(document).ready(function ($) {
    
    $('#store_permanent_url').on('paste', function(e) {
        setTimeout(() => {
            $(e.target.form).submit();
        }, 0);
    });
    
    $('#permanentstore').submit(function (e) {
        const form = e.target;
        const formData = Object.fromEntries(new FormData(form));

        form.classList.add('loading');

        $.post({
            url: lightrcommerce.admin_ajax_url,
            data: formData
        }).done(response => {
            if (response.ok) {
                document.getElementById('store_permanent_url').value = response.permanentUrl;
                document.getElementById('lightrcommerce_store_permanent_url').value = response.permanentUrl;

                const onboardingForm = document.forms['onboarding'];
                onboardingForm.classList.remove('deactivated');
                onboardingForm.scrollIntoView({
                    behavior: 'smooth'
                });
                form.classList.add('valid');
                form.querySelector('.error-msg').textContent = '';
            } else {
                form.classList.add('invalid');

                form.querySelector('.error-msg').textContent = response.error;
            }
        }).fail((jqXHR, textStatus, errorThrown) => {
            form.classList.remove('valid');
            form.classList.remove('invalid');
        }).always(() => {
            form.classList.remove('loading');
        });

        return false;
    });
    
    $('#onboarding').submit(function(e) {
        const form = e.target;
        const formData = Object.fromEntries(new FormData(form));

        form.classList.add('loading');

        $.post({
            url: lightrcommerce.admin_ajax_url,
            data: formData
        }).done(response => {
            if (response.ok) {
                form.classList.add('valid');
                form.querySelector('.error-msg').textContent = '';
                
                document.location.href = response.nextUrl;
            } else {
                form.classList.add('invalid');
                form.querySelector('.error-msg').textContent = response.error;
                form.querySelector('.error-msg').innerHTML += '<p>Are you having problems to complete this wizard? <a href="https://lightrcommerce.com/support/" class="underline" target="_blank">Contact us and we will gladly guide you</a>.</p>'
            }
        }).fail((jqXHR, textStatus, errorThrown) => {
            alert(jqXHR.responseText)
            form.classList.remove('valid');
            form.classList.remove('invalid');
        }).always(() => {
            form.classList.remove('loading');
        });

        return false;
    });

    $('#btn-show-popup').click(function() {
        $("#popup").show();
        $("#darkBg").show();
    });

    $('.popup-closer').click(function() {
        $("#popup").hide();
        $("#darkBg").hide();
    });
});