<?php

namespace LightrCommerce\Plugin\Widget;

use LightrCommerce\Plugin\Widget;
use LightrCommerce\BigCommerce\Core as Api;

class ProductFullDetail extends Widget {

    const CODE = 'ProductFullDetail';

    public function widget($args, $instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'YD Product Full Detail';

        /** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
        $title = apply_filters('widget_title', $title, $instance, $this->id_base);
        $product = isset($instance['product']) ? $instance['product'] : 0;

        echo $args['before_widget']; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        $this->printTemplate(['productId' => $product]);
        echo $title . $args['after_widget']; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }

    /**
     * Outputs the settings form for the Product Categories widget.
     *
     * @param array $instance Current settings.
     */
    public function form($instance) {
        //Defaults
        $instance = wp_parse_args((array) $instance, ['title' => '']);
        
        $this->printProductSelectHtml();
    }

    /**
     * Handles updating settings for the current Product Categories widget instance.
     *
     * @param array $new_instance New settings for this instance as input by the user via
     *                            WP_Widget::form().
     * @param array $old_instance Old settings for this instance.
     *
     * @return array Updated settings to save.
     */
    public function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['product'] = $new_instance['product'];
        return $instance;
    }

    // outputs the options form in the admin
    private function printProductSelectHtml() {
        $products = Api::getProducts();

        ?><label for="<?php esc_attr($this->get_field_id('product')) ?>">Choose Product:</label>
        <select name="<?php esc_attr($this->get_field_name('product')) ?>" id="<?php esc_attr($this->get_field_id('product')) ?>">
        <?php foreach ($products as $product) { ?>
            <option value="<?php esc_attr($product->entityId)?>"><?php esc_html($product->name) ?></option>
        <?php } ?>
        </select>
        <?php
    }
}
